#Encode a song into binary format
from struct import *
import sys


#Usage notice
if len(sys.argv)==1:
  print """usage: 
    python encode.py file1 file2 id

      file1       => name of the input file
      file2       => name of the output binary file
      id          => id of the song
  """
  exit()

#Arguments acquiring
filein      = sys.argv[1] 
fileout     = sys.argv[2]
id_song     = sys.argv[3]

#Resolution computing
NBYTE       = 2
MAX_LENGTH  = 60.0*4 #4 minutes
res         = int( (2**(NBYTE*8)) / MAX_LENGTH )

#open the file that contains the notes
f = open(filein)
lines = f.readlines()
f.close()

#get the number of notes
num = len(lines)

#open the binary file for write 
g = open(fileout,"w")
#write the id of the song, the number of notes
# c = character(1 byte), h = short(2 bytes)
id_song = int(id_song)
g.write(pack("B", id_song))
g.write(pack("h", num))



#Iterating through the beats
for i in range(len(lines)):
  color = int(lines[i].split()[0])
  time  = float(lines[i].split()[1])
  val   =  time*res #timestamp value
  g.write(pack("Bh",color,val))
 

#close binary stream
g.close()

